<?php
session_start();
if ( 'POST' != $_SERVER['REQUEST_METHOD'] ) {
	header('Allow: POST');
	header('HTTP/1.1 405 Method Not Allowed');
	header('Content-Type: text/plain');
	exit;
}

require( dirname(__FILE__).'/../../../../wp-load.php' );
date_default_timezone_set('Asia/Shanghai');
nocache_headers();
$comment_post_ID = isset($_POST['comment_post_ID']) ? (int) $_POST['comment_post_ID'] : 0;
$post = get_post($comment_post_ID);
if ( empty($post->comment_status) ) {
	do_action('comment_id_not_found', $comment_post_ID);
	err(__('获取评论信息失败','mobantu'));
}

if(function_exists('include_ctl_captcha_comment_form')){
	$comment_captcha = get_option('wpcaptcha_comments');
	if($comment_captcha == 'yes'){
		$c_registered = get_option('wpcaptcha_registered');
		if ( is_user_logged_in() && $c_registered == 'yes') {
			//对已登录无效
		}else{
			$captcha_code = ( isset($_POST['captcha_code']) )  ? trim(strip_tags($_POST['captcha_code'])) : '';
			if($captcha_code && $_SESSION['captcha_code'] == $captcha_code){

			}else{
				err(__('验证码错误，请严格区分大小写','mobantu'));
			}
		}
	}
}

$status = get_post_status($post);
$status_obj = get_post_status_object($status);

do_action('pre_comment_on_post', $comment_post_ID);

$comment_author       = ( isset($_POST['author']) )  ? trim(strip_tags($_POST['author'])) : null;
$comment_author_email = ( isset($_POST['email']) )   ? trim($_POST['email']) : null;
$comment_author_url   = ( isset($_POST['url']) )     ? trim($_POST['url']) : null;
$comment_content      = ( isset($_POST['comment']) ) ? trim($_POST['comment']) : null;
$edit_id              = ( isset($_POST['edit_id']) ) ? $_POST['edit_id'] : null; 


// If the user is logged in
$user = wp_get_current_user();

if ( $user->ID ) {
	if ( empty( $user->display_name ) ){
		$user->display_name=$user->user_login;
	}

	$comment_author       = esc_sql($user->display_name);
	$comment_author_email = esc_sql($user->user_email);
	$comment_author_url   = esc_sql($user->user_url);

	if ( current_user_can('unfiltered_html') ) {
		if ( wp_create_nonce('unfiltered-html-comment_' . $comment_post_ID) != $_POST['_wp_unfiltered_html_comment'] ) {
			kses_remove_filters(); // start with a clean slate
			kses_init_filters(); // set up the filters
		}
	}
} else {
	if ( get_option('comment_registration') || 'private' == $status ){
		err(__('你必须登录才能发表评论','mobantu')); 
	}
}


$comment_type = '';
if ( get_option('require_name_email') && !$user->ID ) {
	if ( !$comment_author_email || !$comment_author ){
		err( __('请填写昵称和邮箱','mobantu') ); 
	}
	elseif ( !is_email($comment_author_email)){
		err( __('请填写有效的邮箱地址','mobantu') ); 
	}
}

if ( '' == $comment_content ){
	err( __('请填写点评论','mobantu') ); 
}

function err($ErrMsg) {
    header('HTTP/1.1 405 Method Not Allowed');
    echo $ErrMsg;
    exit;
}

$comment_parent = isset($_POST['comment_parent']) ? absint($_POST['comment_parent']) : 0;

$commentdata = compact('comment_post_ID', 'comment_author', 'comment_author_email', 'comment_author_url', 'comment_content', 'comment_type', 'comment_parent', 'user_ID');


if ( $edit_id ){
	$comment_id = $commentdata['comment_ID'] = $edit_id;
	wp_update_comment( $commentdata );
} else {
	$comment_id = wp_new_comment( $commentdata );
}


$comment = get_comment($comment_id);
if ( !$user->ID ) {
	$comment_cookie_lifetime = apply_filters('comment_cookie_lifetime', 30000000);
	setcookie('comment_author_' . COOKIEHASH, $comment->comment_author, time() + $comment_cookie_lifetime, COOKIEPATH, COOKIE_DOMAIN);
	setcookie('comment_author_email_' . COOKIEHASH, $comment->comment_author_email, time() + $comment_cookie_lifetime, COOKIEPATH, COOKIE_DOMAIN);
	setcookie('comment_author_url_' . COOKIEHASH, esc_url($comment->comment_author_url), time() + $comment_cookie_lifetime, COOKIEPATH, COOKIE_DOMAIN);
}


$comment_depth = 1;
$tmp_c = $comment;
while($tmp_c->comment_parent != 0){
	$comment_depth++;
	$tmp_c = get_comment($tmp_c->comment_parent);
}

echo '<li '; comment_class(); echo ' id="comment-'.get_comment_ID().'">';
echo '<div class="comt-avatar">';
	MBThemes_avatar($comment->comment_author_email);
echo '</div>';
echo '<div class="comt-main" id="div-comment-'.get_comment_ID().'">';
    echo do_shortcode(convert_smilies(get_comment_text()));
	echo '<div class="comt-meta">';
		if ($comment->comment_approved == '0'){
	    	echo '<span class="comt-approved">'.__('待审核','mobantu').'</span>';
	    }
		echo '<span class="comt-author">'.get_comment_author_link().'</span>';
    	echo date('G:i', strtotime($comment->comment_date));
	echo '</div>';
echo '</div>';
exit;